require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require 'watir-scroll'
require_relative '../base/base'
require_relative '../../module/DateUtility'
require_relative '../../common/common'
require_relative '../../helper/modal'

class NewAppointmentRequest < Base
  include PageObject
  include DateUtility
  @@bookedDate
  def initialize(driver)
    super(driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
  end


  def self.bookedDate
    @@bookedDate
  end
  h2(:title, :css => '.primary-header h2')
  expected_title "New Appointment/Request"

  #facility
  div(:facility_section, :css=>'.scheduling-facility')

  legend(:facility_label, :css=>'.scheduling-facility .subheading')
  span(:single_facility, :id =>'facility')
  radio_button_group(:facility_radio, :name=>'facility')

  select_list(:type_of_care, :id =>'typeOfCare')
  p(:express_care_end_time, :css=>'.express-time')

  div(:provider_section, :css=>'.providers-section')
  link(:pact_529_link, :css=>'a[href="#529"]')

  div(:scheduling_method_section, :css=>'.scheduling-method')
  radio_button_group(:scheduling_method_radio, :name=> 'scheduling-method')


  legend(:appointment_details_legend, :id=>'appointment-details')
  legend(:request_details_legend, :id =>'request-details')
  form(:entryForm, :id => 'new-appointment-request-form')

  div(:direct_appoitnment_no_pact_team_error, :css=> 'label[for="scheduling-method-direct"] div')
  div(:request_limit_reached_error, :css=>'label[for="scheduling-method-clerk"] .max-appointment-type-warning')


  text_field(:preferred_provider_text, :id =>'providerName')
  #radio_button_group(:type_of_visit_radio, :name=>'visitType')
  radio_button_group(:type_of_visit_radio, :css=>'.form-section .ui-body.ui-corner-all label[for*="visit"] input')
  div(:video_conference_warning, :css=>'.video-conference-warning')
  div(:phone_call_warning, :css=>'.phone-call-warning')

  select_list(:purpose_of_visit, :id=>'purposeOfVisit')
  text_field(:other_purpose_text, :id=>'otherPurposeOfVisit')

  text_field(:option_date1, :id=>'optionDate1')
  text_field(:option_date2, :id=>'optionDate2')
  text_field(:option_date3, :id=>'optionDate3')

  button(:option_date_calendar1, :id=>'optionDate1-datepicker-btn')
  button(:option_date_calendar2, :id=>'optionDate2-datepicker-btn')
  button(:option_date_calendar3, :id=>'optionDate3-datepicker-btn')

  #error message
  div(:option_date1_error, :id=>'optionDate1-error-inline')
  div(:option_date2_error, :id=>'optionDate2-error-inline')
  div(:option_date3_error, :id=>'optionDate3-error-inline')

  #day of the week
  span(:optionDate1_day, :id=>'optionDate1-day')
  span(:optionDate2_day, :id=>'optionDate2-day')
  span(:optionDate3_day, :id=>'optionDate3-day')

  radio_button_group(:am_pm1, :name=>'optionTime1')
  radio_button_group(:am_pm2, :name=>'optionTime2')
  radio_button_group(:am_pm3, :name=>'optionTime3')

  radio_button_group(:requestedPhoneCall, :name=>'requestedPhoneCall')
  label(:requestedPhoneCall_yes, :css =>'label[for="requestedPhoneCall-yes"]')
  label(:requestedPhoneCall_no, :css =>'label[for="requestedPhoneCall-no"]')

  text_field(:phoneNumber, :id =>'phoneNumber')
  text_field(:verifyPhoneNumber, :id =>'verifyPhoneNumber')

  #phone number error
  div(:phone_number_error, :id=>'phoneNumber-error-inline')
  div(:verify_phone_number_error, :id=>'verifyPhoneNumber-error-inline')

  checkbox(:bestTimeToCall_morning, :id=>'bestTimetoCall-morning')
  checkbox(:bestTimeToCall_afternoon, :id=>'bestTimetoCall-afternoon')
  checkbox(:bestTimeToCall_evening, :id=>'bestTimetoCall-evening')


  span(:message_header, :css =>'.new-message-question .label-text')
  textarea(:new_message, :id =>'newMessage')
  p(:message_counter, :css =>'.new-message-question .textarea-counter')

  #appoitnment details
  #clinic
  #elements(:facility_group, :label, :css=>'.appointment-details-facility-providers-section .ui-controlgroup label')
  span(:single_clinic_label, :css=>'span[for="clinic"] .label-text')
  radio_button_group(:clinic_radio, :name=>'clinic')
  span(:single_clinic_info, :id=>'clinic')
  legend(:multi_clinic_label, :css=>'legend[for="clinic"]')
  elements(:clinic_group, :label, :css=>'div.appointment-details-clinics-section .ui-controlgroup label')

  text_area(:reason, :id =>'purpose')

  #preferred date
  text_field(:preferred_date, :id=>'desiredDate')
  button(:show_availability, :css =>'#show-availability-btn')
  button(:show_all_dates, :id =>'show-all-dates-btn')
  link(:no_date_time_that_works, :id=>'no-date-time-that-works')
  link(:collapse_slots, :css=>'.ui-collapsible-heading-toggle')

  p(:preferred_date_info_text, :css=>'.form-input-datepicker-description')
  p(:select_datetime_instr_text, :id=>'available-dates-times-description')
  element(:date_time_section, :fieldset, :css=>'.available-dates-times-section fieldset')
  elements(:date_time_section_list, :div, :css=>'.available-dates-times-section fieldset div')
  span(:selected_datetime_info_label, :css =>'.appointment-details-selected-date-time-slot .label-text')
  span(:selected_datetime_info, :id =>'dateTime')
  elements(:all_dates, :h5, :css=>'.available-dates-times-collapsibles h5')
  element(:select_first_date_from_list, :span, :css=>'.available-dates .ui-collapsible:nth-of-type(1) span')
  button(:select_first_slot_from_list, :css=>'.available-time-slots button:nth-of-type(1)')


  #express care
  div(:request_details_section, :css=>'.request-details-type-purpose-section')
  select_list(:reason_for_visit, :id=>'reasonForVisit')
  text_area(:additional_information, :id=>'additionalInformation')
  text_field(:other_reason_for_visit, :id=>'otherReasonForVisit')
  div(:communicating_section, :css=>'.request-details-phone-contact-section')
  p(:additional_info_message_counter, :css =>'.request-details-type-purpose-section .textarea-counter')


  #notification settings
  div(:notification_section,  :css=>'.new-appointments-email')

  #email
  button(:notification_setting, :id => 'notification-info-btn')
  radio_button_group(:emailPref, :name=>'emailAllowed')
  text_field(:email, :id =>'emailAddress')

  #action button
  button(:selectDate, :css => "#desiredDate-datepicker-btn")
  button(:submit, :id => 'submit-request-btn')
  button(:schedule_appointment, :css =>'#schedule-appointment-btn')
  button(:cancel, :id=> 'new-appointment-request-cancel')

  #new_appointment_request_form
  button(:back_btn, :id => "back-btn")
  #legend(:step_1_type_of_care,:css => "#new-appointment-request-form > div.facility-care-and-scheduling-section.modal-content-section > div > div.scheduling-type-of-care > div > div.step-heading > div > legend'")
  legend(:step_1_type_of_care, :css=>"#new-appointment-request-form div.scheduling-type-of-care div.step-heading legend")
  p(:instructional_text_type_of_care, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-type-of-care > div > div.step-heading > div > p")
  legend(:step_2_location, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-facility > div > div.step-heading > div > legend")
  select_list(:location, :id =>'facility')
  p(:location_instruction,:css => ".scheduling-facility .step-instructions")
  span(:single_location,:id => 'facility')
  a(:va_facility,:css => "#new-appointment-request-form > div.facility-care-and-scheduling-section.modal-content-section > div > div.scheduling-facility > div > div.step-heading > div > p > a")
  #legend(:step_3_scheduling_method,:css => "#new-appointment-request-form > div.facility-care-and-scheduling-section.modal-content-section > div > div.scheduling-method > div > div.step-heading > div > legend")
  legend(:step_3_scheduling_method, :css=>"#new-appointment-request-form div.scheduling-method div.step-heading legend")
  p(:scheduling_method_instruction, :css => "#new-appointment-request-form > div.facility-care-and-scheduling-section.modal-content-section > div > div.scheduling-method > div > div.step-heading > div > p")
  div(:no_pact_team_message_direct, :css => "#new-appointment-request-form > div.facility-care-and-scheduling-section.modal-content-section > div > div.scheduling-method > div > div.step-section > fieldset > div > fieldset > div > label.ui-disabled > div")
  div(:patient_history_limit_myself, :css => "label[for='scheduling-method-direct'] div")
  div(:patient_history_limit_clerk, :css => "label[for='scheduling-method-clerk'] div")
  radio_button(:scheduling_method_direct, :id => 'scheduling-method-direct')
  radio_button(:scheduling_method_clerk, :id => 'scheduling-method-clerk')

  radio_button(:clinic_19, :id => 'clinic-19')
  div(:mutiple_clinics, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-details > fieldset > div.appointment-details-clinics-section > div > div > fieldset > div > fieldset > div")
  span(:day, :css => "#desiredDate-day > span:nth-child(2)")
  p(:appt_details_date_time_slot, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-details > fieldset > div.appointment-details-date-time-section > div > div.selected-date-time-slot-section > p")
  span(:verify_selected_slot_txt, :css =>".appointment-details-selected-date-time-slot span#dateTime")
  #state city
  div(:city_state_section, :css=>'.scheduling-city-state')
  select_list(:city_state, :id =>'cityState')

  #pact-team
  div(:pact_team, :css => ".step-section .field-contain + div")
  a(:view_pact_team, :css => ".pact-team-link")
  div(:single_facility_pact, :css =>'#single-item-pact')
  #Video Vists and Hospital Icons
  span(:vv_icon, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-details > fieldset > div.appointment-details-clinics-section > div > div > fieldset > div > fieldset > div > label:nth-child(1) > span > span > span.clinic.icon-video")
  span(:hospital_icon, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-details > fieldset > div.appointment-details-clinics-section > div > div > fieldset > div > fieldset > div > label:nth-child(10) > span > span > span.clinic.icon-hospital")
  p(:instructional_text_video_appt_clinic, :css => "#new-appointment-request-form > div.new-appointments-steps.modal-content-section > div > div.scheduling-details > fieldset > div.appointment-details-clinics-section > div > div > fieldset > div > fieldset > div > label:nth-child(1) > span > span > span.clinic.label-text.label-details > span > p")
  p(:instructional_text_video_appt_noti_settings, :css => "#new-appointment-request-form > div.new-appointments-email > fieldset > p")

  def getScreenContent()
    return entryForm_element.text
  end

  def getDateElement(dateStr)
    formattedDateStr = getFormatedDateStr(dateStr, "%m/%d/%Y", "%m-%d-%Y")
    self.class.h5(:date, :id =>'available-slots-on-' + formattedDateStr)
    return self.date_element
  end

  def isDateElementPresent(dateStr)
    formattedDateStr = getFormatedDateStr(dateStr, "%m/%d/%Y", "%m-%d-%Y")
    self.class.h5(:selectedDate, :id =>'available-slots-on-' + formattedDateStr)

    return self.selectedDate_element.exists?
  end

  def getMonthElement(monthStr, yearStr)
    self.class.h4(:month, :id =>'available-slots-in-' +  monthStr.downcase + '-' + yearStr)
    return self.month_element
  end

  def getTimeSlotElement(date, time)
    formattedDateStr = getFormatedDateStr(date, "%m/%d/%Y", "%m-%d-%Y")
    self.class.button(:time, :id =>'time-slot-' + formattedDateStr + '-' + time.sub(":", "-"))
    return self.time_element
  end

  def isElementCollapsed(element)
    return element.attribute("class").include? "ui-collapsible-heading-collapsed"
  end

  def selectTimeSlot(date, time)
    formattedDateStr = getFormatedDateStr(date, "%m/%d/%Y", "%m-%d-%Y")
    self.class.button(:time, :id =>'time-slot-' + formattedDateStr + '-' + time.sub(":", "-"))
    self.time_element.click
  end

  def isAllDatesCollapsed()
    dateCount = all_dates_elements.length - 1
    isElementCollapsed = true

    for i in 0...dateCount
      if  ! all_dates_elements[i].attribute("class").include?("ui-collapsible-heading-collapsed")
        isElementCollapsed = false
        break
      end
    end

    return isElementCollapsed

  end

  def selectTypeOfCare(typeofcare)
    step_1_type_of_care_element.wait_until_present(TIME_OUT_LIMIT)
    if typeofcare.downcase == 'primary care'
      type_of_care_element[1].click
      elsif typeofcare.downcase == 'audiology'
        type_of_care_element[2].click
      elsif typeofcare.downcase == 'express care'
        type_of_care_element[3].click
      elsif typeofcare.downcase == 'optometry'
        type_of_care_element[4].click
      elsif typeofcare.downcase == 'outpatient mental health'
        type_of_care_element[5].click
    else
      fail "Requested type of care not found. Please add"
    end
    @common.waitWhileSpinnerPresent

  end

  def selectState(stateValue)
    city_state_element.wait_until_present(TIME_OUT_LIMIT)
    city_state_element.select_value(stateValue)
    @common.waitWhileSpinnerPresent

  end

  def selectLocation(locationValue)
    location_element.wait_until_present(TIME_OUT_LIMIT)
    location_element.select_value(locationValue)
    @common.waitWhileSpinnerPresent
  end

  def selectSchedulingMethod(schedulingMethod)
    step_3_scheduling_method_element.when_present(TIME_OUT_LIMIT)
    select_scheduling_method_radio(schedulingMethod)
    @common.waitWhileSpinnerPresent
  end

  def selectClinic(clinicValue)
    Watir::Wait.until {clinic_radio_elements[1].present?}
    select_clinic_radio(clinicValue)
    @common.waitWhileSpinnerPresent
  end

  def provideReasonForAppointment(reasonForAppointment)
    reason_element.when_present(TIME_OUT_LIMIT)
    self.reason=reasonForAppointment
  end

  def verifySelectedSlotTxt
    (self.verify_selected_slot_txt_element).visible?
  end

  def selectPreferedDate(date, timeSlot)
    preferred_date_element.when_present(TIME_OUT_LIMIT)
    self.preferred_date=date
    self.show_availability
    if (self.select_datetime_instr_text).present?
      date = select_first_date_from_list
      @@bookedDate=date
      self.preferred_date=date
      self.show_availability
      Watir::Wait.until { self.isDateElementPresent(date)}
      self.show_all_dates
      @common.waitWhileSpinnerPresent
      self.selectTimeSlot(date, timeSlot)
    else
      @@bookedDate=date
      Watir::Wait.until { self.isDateElementPresent(date)}
      self.show_all_dates
      @common.waitWhileSpinnerPresent
      self.selectTimeSlot(date, timeSlot)
    end


  end

  def enterEmail(emailAddress)
    self.select_emailPref("true")
    self.email = emailAddress
    self.email_element.fire_event('onblur')
  end

  def clickConfirmAppointment
    confirm_appointment_element.wait_until_present(TIME_OUT_LIMIT)
    confirm_appointment_element.click
  end

  def clickSubmitRequest
    schedule_appointment_element.wait_until_present(TIME_OUT_LIMIT)
    button_element = @driver.button(:id => 'schedule-appointment-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    #self.schedule_appointment
    @common.waitWhileSpinnerPresent()
  end

  def clickScheduleAppointment
    sleep 2
    schedule_appointment_element.when_visible(TIME_OUT_LIMIT)
    schedule_appointment_element.scroll.to :top
    self.schedule_appointment
    @common.waitWhileSpinnerPresent()
  end

  def createAppointment(typeofcare, locationName, clinicName, reason, date, timeSlot, email)
    selectTypeOfCare(typeofcare)
    selectState(locationName)
    selectLocation(locationName)
    step_3_scheduling_method_element.wait_until_present(TIME_OUT_LIMIT)
    select_scheduling_method_radio("direct")
    @common.waitWhileSpinnerPresent
    selectClinic(clinicName)
    @common.waitWhileSpinnerPresent
    provideReasonForAppointment(reason)
    selectPreferedDate(date, timeSlot)
    enterEmail(email)
    clickSubmitRequest
    @common.waitWhileSpinnerPresent()
  end

  def selectNewAppointmentAndSchedule(typeOfCare, stateId, facilityId, schedulingMethod)
    @common.waitWhileSpinnerPresent()
    selectTypeOfCare(typeOfCare)
    selectState(stateId)
    selectLocation(facilityId)
    selectSchedulingMethod(schedulingMethod)
    @common.waitWhileSpinnerPresent
  end

  def cancelForm
    back_btn
    @common.waitWhileSpinnerPresent
    @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
    @modal.buttons_elements[0].click
    @common.waitWhileSpinnerPresent
  end

  def addExpressCare
    self.reason_for_visit = "Ear Problem"
    self.additional_information = "Adding 2nd Express Care Request"
    self.additional_information_element.fire_event("onblur")
    self.phoneNumber = "7032223333"
    self.phoneNumber_element.fire_event("onblur")
    self.verifyPhoneNumber = "7032223333"
    self.check_bestTimeToCall_morning
    self.check_bestTimeToCall_afternoon
    self.requestedPhoneCall_yes_element.click
    self.email = "test@test.com"
    self.email_element.fire_event("onblur")
    self.clickSubmitRequest
    @common.waitWhileSpinnerPresent
  end


end
